package com.ejie.ab04b.validation;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab04b.exception.ErrorField;

/**
 * Clase que deben extender todos los validadores.<br/>
 * Se <u>deben sobreescribir</u> de los metodos: <b>validateAdd, validateEdit y
 * validateAny</b>, los que se quieran utilizar.
 * 
 <T>
 *            Tipo de objeto para el que se realizan las validaciones
 * 
 * @author GFI-NORTE
 */
public abstract class AbstractPRLValidator<T> {

	/**
	 * Tipo de operacion que se quiere validar: Añadir o Editar
	 */
	public static enum Oper {
		EDIT_TAB_NOTIFICACION, EDIT_TAB_EMPRESAOS2, EDIT_TAB_AUDITORIA, EDIT_TAB_EMPRESAOS3, EDIT_TAB_PREVENCIONOS2, EDIT_TAB_PREVENCIONOS3
	}

	/**
	 * Method 'EntidadValidator'.
	 */
	protected AbstractPRLValidator() {
		super();
	}

	/**
	 * Metodo validador para la operacion ADD_PRESENCIAL.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 * 
	 *            abstract void validateAddPresencial(List
	 *            <ErrorField> errorFields, T object);
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */

	/**
	 * Metodo validador para la operacion ADD_PRESENCIAL
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 * 
	 *            abstract void validateAddTelematica(List
	 *            <ErrorField> errorFields, T object);
	 */

	/**
	 * Metodo validador para la operacion EDIT.
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 * 
	 *            abstract void validateEdit(List<ErrorField> errorFields, T
	 *            object);
	 */

	/**
	 * Metodo validador para la operacion EDIT_TAB_EMPRESAOS3.
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 */
	abstract void validateEditTabEmpresaOS3(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_PREVENCIONOS2.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabPrevencionOS2(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_PREVENCIONOS3.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabPrevencionOS3(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_NOTIFICACIONOS2.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabNotificacion(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_EMPRESAOS2.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabEmpresaOS2(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_AUDITORIA.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabAuditoria(List<ErrorField> errorFields,
			T object);
	
	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateLocalidadCP(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida el model.
	 * 
	 *  object
	 *            Tipo
	 *  oper
	 *            Oper
	 *  List<ErrorField>
	 *
	 * @param object the object
	 * @param oper the oper
	 * @return the list
	 */
	public List<ErrorField> validate(T object, Oper oper) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();
		switch (oper) {
		case EDIT_TAB_NOTIFICACION:
			this.validateEditTabNotificacion(errorFields, object);
			break;
		case EDIT_TAB_EMPRESAOS2:
			this.validateEditTabEmpresaOS2(errorFields, object);
			break;
		case EDIT_TAB_AUDITORIA:
			this.validateEditTabAuditoria(errorFields, object);
			break;
		case EDIT_TAB_EMPRESAOS3:
			this.validateEditTabEmpresaOS3(errorFields, object);
			break;
		case EDIT_TAB_PREVENCIONOS2:
			this.validateEditTabPrevencionOS2(errorFields, object);
			break;
		case EDIT_TAB_PREVENCIONOS3:
			this.validateEditTabPrevencionOS3(errorFields, object);
			break;
		default:

			break;
		}
		return errorFields;
	}
	
	/**
	 * Valida el model.
	 * 
	 *  object
	 *            Tipo
	 *  List<ErrorField>
	 *
	 * @param object the object
	 * @return the list
	 */
	public List<ErrorField> validateLocalidadCP(T object) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();
		
		this.validateLocalidadCP(errorFields, object);
		
		return errorFields;
	}

}